document.addEventListener('DOMContentLoaded', () => {
  const toggle = document.getElementById('video-theme-toggle');
  const body = document.body;
  const icon = toggle.querySelector('i');
  const savedTheme = localStorage.getItem('akkul-video-theme');

  // Apply saved theme
  if (savedTheme === 'dark') {
    body.classList.add('dark');
    icon.classList.remove('fa-moon');
    icon.classList.add('fa-sun');
  }

  toggle.addEventListener('click', () => {
    body.classList.toggle('dark');
    const isDark = body.classList.contains('dark');
    if (isDark) {
      icon.classList.remove('fa-moon');
      icon.classList.add('fa-sun');
      localStorage.setItem('akkul-video-theme', 'dark');
    } else {
      icon.classList.remove('fa-sun');
      icon.classList.add('fa-moon');
      localStorage.setItem('akkul-video-theme', 'light');
    }
  });
});